%------------------------------------------------------------------------------
% File     : DAT206^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Sorted list operations 216
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Lam09] Lammich (2009), Collections Framework
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : sorted_list_operations__216.p [Bla16]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.5.0, 0.33 v7.2.0, 0.50 v7.1.0
% Syntax   : Number of formulae    :  333 (  60 unt;  53 typ;   0 def)
%            Number of atoms       :  934 ( 212 equ;   0 cnn)
%            Maximal formula atoms :   13 (   3 avg)
%            Number of connectives : 4212 ( 132   ~;  19   |;  64   &;3410   @)
%                                         (   0 <=>; 587  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   24 (   9 avg)
%            Number of types       :    2 (   1 usr)
%            Number of type conns  :  249 ( 249   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   55 (  52 usr;   8 con; 0-4 aty)
%            Number of variables   : 1153 (  48   ^;1018   !;  43   ?;1153   :)
%                                         (  44  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:41:16.069
%------------------------------------------------------------------------------
%----Could-be-implicit typings (4)
thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (49)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Ono__bot,type,
    no_bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Ono__top,type,
    no_top: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder__top,type,
    order_top: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Odense__order,type,
    dense_order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Conditionally__Complete__Lattices_Olinear__continuum,type,
    condit1656338222tinuum: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Conditionally__Complete__Lattices_Oconditionally__complete__linorder,type,
    condit1037483654norder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Ocoset,type,
    coset: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olinorder__class_Osorted,type,
    linorder_sorted: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : ( list @ A ) ).

thf(sy_c_List_Olist_Oset,type,
    set2: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Oproduct__lists,type,
    product_lists: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Osublists,type,
    sublists: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Ounion,type,
    union: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List__More_Ocombinatorial__product,type,
    list_c659805718roduct: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_Misc_Omergesort__remdups,type,
    mergesort_remdups: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Orderings_Oord_Omax,type,
    max: 
      !>[A: $tType] : ( ( A > A > $o ) > A > A > A ) ).

thf(sy_c_Orderings_Oord_Omin,type,
    min: 
      !>[A: $tType] : ( ( A > A > $o ) > A > A > A ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oorder__class_Ostrict__mono,type,
    order_strict_mono: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > $o ) ).

thf(sy_c_Orderings_Oordering__top,type,
    ordering_top: 
      !>[A: $tType] : ( ( A > A > $o ) > ( A > A > $o ) > A > $o ) ).

thf(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oremove,type,
    remove: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_Sorted__List__Operations__Mirabelle__fineeiboro_Osubset__sorted,type,
    sorted1061247458sorted: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > $o ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_l1,type,
    l1: list @ a ).

thf(sy_v_l1a____,type,
    l1a: list @ a ).

thf(sy_v_l2,type,
    l2: list @ a ).

thf(sy_v_l2b____,type,
    l2b: list @ a ).

thf(sy_v_x1____,type,
    x1: a ).

thf(sy_v_x2____,type,
    x2: a ).

%----Relevant facts (255)
thf(fact_0_x1__neq__x2,axiom,
    x1 != x2 ).

% x1_neq_x2
thf(fact_1_x2__le__x1,axiom,
    ~ ( ord_less @ a @ x1 @ x2 ) ).

% x2_le_x1
thf(fact_2_minf_I11_J,axiom,
    ! [C: $tType,D: $tType] :
      ( ( ord @ C @ ( type2 @ C ) )
     => ! [F: D] :
        ? [Z: C] :
        ! [X: C] :
          ( ( ord_less @ C @ X @ Z )
         => ( F = F ) ) ) ).

% minf(11)
thf(fact_3_minf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X: A] :
          ( ( ord_less @ A @ X @ Z )
         => ~ ( ord_less @ A @ T @ X ) ) ) ).

% minf(7)
thf(fact_4_minf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X: A] :
          ( ( ord_less @ A @ X @ Z )
         => ( ord_less @ A @ X @ T ) ) ) ).

% minf(5)
thf(fact_5_minf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X: A] :
          ( ( ord_less @ A @ X @ Z )
         => ( X != T ) ) ) ).

% minf(4)
thf(fact_6_minf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X: A] :
          ( ( ord_less @ A @ X @ Z )
         => ( X != T ) ) ) ).

% minf(3)
thf(fact_7_minf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P2: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z2: A] :
            ! [X2: A] :
              ( ( ord_less @ A @ X2 @ Z2 )
             => ( ( P @ X2 )
                = ( P2 @ X2 ) ) )
         => ( ? [Z2: A] :
              ! [X2: A] :
                ( ( ord_less @ A @ X2 @ Z2 )
               => ( ( Q @ X2 )
                  = ( Q2 @ X2 ) ) )
           => ? [Z: A] :
              ! [X: A] :
                ( ( ord_less @ A @ X @ Z )
               => ( ( ( P @ X )
                    | ( Q @ X ) )
                  = ( ( P2 @ X )
                    | ( Q2 @ X ) ) ) ) ) ) ) ).

% minf(2)
thf(fact_8_minf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P2: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z2: A] :
            ! [X2: A] :
              ( ( ord_less @ A @ X2 @ Z2 )
             => ( ( P @ X2 )
                = ( P2 @ X2 ) ) )
         => ( ? [Z2: A] :
              ! [X2: A] :
                ( ( ord_less @ A @ X2 @ Z2 )
               => ( ( Q @ X2 )
                  = ( Q2 @ X2 ) ) )
           => ? [Z: A] :
              ! [X: A] :
                ( ( ord_less @ A @ X @ Z )
               => ( ( ( P @ X )
                    & ( Q @ X ) )
                  = ( ( P2 @ X )
                    & ( Q2 @ X ) ) ) ) ) ) ) ).

% minf(1)
thf(fact_9_pinf_I11_J,axiom,
    ! [C: $tType,D: $tType] :
      ( ( ord @ C @ ( type2 @ C ) )
     => ! [F: D] :
        ? [Z: C] :
        ! [X: C] :
          ( ( ord_less @ C @ Z @ X )
         => ( F = F ) ) ) ).

% pinf(11)
thf(fact_10_pinf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X: A] :
          ( ( ord_less @ A @ Z @ X )
         => ( ord_less @ A @ T @ X ) ) ) ).

% pinf(7)
thf(fact_11_pinf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X: A] :
          ( ( ord_less @ A @ Z @ X )
         => ~ ( ord_less @ A @ X @ T ) ) ) ).

% pinf(5)
thf(fact_12_pinf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X: A] :
          ( ( ord_less @ A @ Z @ X )
         => ( X != T ) ) ) ).

% pinf(4)
thf(fact_13_pinf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X: A] :
          ( ( ord_less @ A @ Z @ X )
         => ( X != T ) ) ) ).

% pinf(3)
thf(fact_14_pinf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P2: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z2: A] :
            ! [X2: A] :
              ( ( ord_less @ A @ Z2 @ X2 )
             => ( ( P @ X2 )
                = ( P2 @ X2 ) ) )
         => ( ? [Z2: A] :
              ! [X2: A] :
                ( ( ord_less @ A @ Z2 @ X2 )
               => ( ( Q @ X2 )
                  = ( Q2 @ X2 ) ) )
           => ? [Z: A] :
              ! [X: A] :
                ( ( ord_less @ A @ Z @ X )
               => ( ( ( P @ X )
                    & ( Q @ X ) )
                  = ( ( P2 @ X )
                    & ( Q2 @ X ) ) ) ) ) ) ) ).

% pinf(1)
thf(fact_15_pinf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P2: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z2: A] :
            ! [X2: A] :
              ( ( ord_less @ A @ Z2 @ X2 )
             => ( ( P @ X2 )
                = ( P2 @ X2 ) ) )
         => ( ? [Z2: A] :
              ! [X2: A] :
                ( ( ord_less @ A @ Z2 @ X2 )
               => ( ( Q @ X2 )
                  = ( Q2 @ X2 ) ) )
           => ? [Z: A] :
              ! [X: A] :
                ( ( ord_less @ A @ Z @ X )
               => ( ( ( P @ X )
                    | ( Q @ X ) )
                  = ( ( P2 @ X )
                    | ( Q2 @ X ) ) ) ) ) ) ) ).

% pinf(2)
thf(fact_16_ex__gt__or__lt,axiom,
    ! [A: $tType] :
      ( ( condit1656338222tinuum @ A @ ( type2 @ A ) )
     => ! [A2: A] :
        ? [B2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
          | ( ord_less @ A @ B2 @ A2 ) ) ) ).

% ex_gt_or_lt
thf(fact_17_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( X3 != Y )
         => ( ~ ( ord_less @ A @ X3 @ Y )
           => ( ord_less @ A @ Y @ X3 ) ) ) ) ).

% linorder_neqE_linordered_idom
thf(fact_18_dual__order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A] :
          ( ( ord_less @ A @ B3 @ A2 )
         => ( A2 != B3 ) ) ) ).

% dual_order.strict_implies_not_eq
thf(fact_19_linordered__field__no__ub,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [X: A] :
        ? [X1: A] : ( ord_less @ A @ X @ X1 ) ) ).

% linordered_field_no_ub
thf(fact_20_linordered__field__no__lb,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [X: A] :
        ? [Y2: A] : ( ord_less @ A @ Y2 @ X ) ) ).

% linordered_field_no_lb
thf(fact_21_order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( A2 != B3 ) ) ) ).

% order.strict_implies_not_eq
thf(fact_22_dependent__wellorder__choice,axiom,
    ! [B: $tType,A: $tType] :
      ( ( wellorder @ A @ ( type2 @ A ) )
     => ! [P: ( A > B ) > A > B > $o] :
          ( ! [R: B,F2: A > B,G: A > B,X2: A] :
              ( ! [Y3: A] :
                  ( ( ord_less @ A @ Y3 @ X2 )
                 => ( ( F2 @ Y3 )
                    = ( G @ Y3 ) ) )
             => ( ( P @ F2 @ X2 @ R )
                = ( P @ G @ X2 @ R ) ) )
         => ( ! [X2: A,F2: A > B] :
                ( ! [Y3: A] :
                    ( ( ord_less @ A @ Y3 @ X2 )
                   => ( P @ F2 @ Y3 @ ( F2 @ Y3 ) ) )
               => ? [X12: B] : ( P @ F2 @ X2 @ X12 ) )
           => ? [F2: A > B] :
              ! [X: A] : ( P @ F2 @ X @ ( F2 @ X ) ) ) ) ) ).

% dependent_wellorder_choice
thf(fact_23_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ~ ( ord_less @ A @ X3 @ Y ) )
          = ( ( ord_less @ A @ Y @ X3 )
            | ( X3 = Y ) ) ) ) ).

% not_less_iff_gr_or_eq
thf(fact_24_dual__order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A,C2: A] :
          ( ( ord_less @ A @ B3 @ A2 )
         => ( ( ord_less @ A @ C2 @ B3 )
           => ( ord_less @ A @ C2 @ A2 ) ) ) ) ).

% dual_order.strict_trans
thf(fact_25_less__imp__not__less,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ~ ( ord_less @ A @ Y @ X3 ) ) ) ).

% less_imp_not_less
thf(fact_26_order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( ord_less @ A @ B3 @ C2 )
           => ( ord_less @ A @ A2 @ C2 ) ) ) ) ).

% order.strict_trans
thf(fact_27_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F3: B > A,B3: B,C2: B] :
          ( ( A2
            = ( F3 @ B3 ) )
         => ( ( ord_less @ B @ B3 @ C2 )
           => ( ! [X2: B,Y2: B] :
                  ( ( ord_less @ B @ X2 @ Y2 )
                 => ( ord_less @ A @ ( F3 @ X2 ) @ ( F3 @ Y2 ) ) )
             => ( ord_less @ A @ A2 @ ( F3 @ C2 ) ) ) ) ) ) ).

% ord_eq_less_subst
thf(fact_28_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B3: A,F3: A > B,C2: B] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( ( F3 @ B3 )
              = C2 )
           => ( ! [X2: A,Y2: A] :
                  ( ( ord_less @ A @ X2 @ Y2 )
                 => ( ord_less @ B @ ( F3 @ X2 ) @ ( F3 @ Y2 ) ) )
             => ( ord_less @ B @ ( F3 @ A2 ) @ C2 ) ) ) ) ) ).

% ord_less_eq_subst
thf(fact_29_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F3: B > A,B3: B,C2: B] :
          ( ( ord_less @ A @ A2 @ ( F3 @ B3 ) )
         => ( ( ord_less @ B @ B3 @ C2 )
           => ( ! [X2: B,Y2: B] :
                  ( ( ord_less @ B @ X2 @ Y2 )
                 => ( ord_less @ A @ ( F3 @ X2 ) @ ( F3 @ Y2 ) ) )
             => ( ord_less @ A @ A2 @ ( F3 @ C2 ) ) ) ) ) ) ).

% order_less_subst1
thf(fact_30_order__less__subst2,axiom,
    ! [A: $tType,C: $tType] :
      ( ( ( order @ C @ ( type2 @ C ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B3: A,F3: A > C,C2: C] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( ord_less @ C @ ( F3 @ B3 ) @ C2 )
           => ( ! [X2: A,Y2: A] :
                  ( ( ord_less @ A @ X2 @ Y2 )
                 => ( ord_less @ C @ ( F3 @ X2 ) @ ( F3 @ Y2 ) ) )
             => ( ord_less @ C @ ( F3 @ A2 ) @ C2 ) ) ) ) ) ).

% order_less_subst2
thf(fact_31_lt__ex,axiom,
    ! [A: $tType] :
      ( ( no_bot @ A @ ( type2 @ A ) )
     => ! [X3: A] :
        ? [Y2: A] : ( ord_less @ A @ Y2 @ X3 ) ) ).

% lt_ex
thf(fact_32_gt__ex,axiom,
    ! [A: $tType] :
      ( ( no_top @ A @ ( type2 @ A ) )
     => ! [X3: A] :
        ? [X1: A] : ( ord_less @ A @ X3 @ X1 ) ) ).

% gt_ex
thf(fact_33_neqE,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( X3 != Y )
         => ( ~ ( ord_less @ A @ X3 @ Y )
           => ( ord_less @ A @ Y @ X3 ) ) ) ) ).

% neqE
thf(fact_34_neq__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( X3 != Y )
          = ( ( ord_less @ A @ X3 @ Y )
            | ( ord_less @ A @ Y @ X3 ) ) ) ) ).

% neq_iff
thf(fact_35_order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ~ ( ord_less @ A @ B3 @ A2 ) ) ) ).

% order.asym
thf(fact_36_dense,axiom,
    ! [A: $tType] :
      ( ( dense_order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ? [Z: A] :
              ( ( ord_less @ A @ X3 @ Z )
              & ( ord_less @ A @ Z @ Y ) ) ) ) ).

% dense
thf(fact_37_less__imp__neq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ( X3 != Y ) ) ) ).

% less_imp_neq
thf(fact_38_less__asym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ~ ( ord_less @ A @ Y @ X3 ) ) ) ).

% less_asym
thf(fact_39_less__asym_H,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ~ ( ord_less @ A @ B3 @ A2 ) ) ) ).

% less_asym'
thf(fact_40_less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Z3: A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ( ( ord_less @ A @ Y @ Z3 )
           => ( ord_less @ A @ X3 @ Z3 ) ) ) ) ).

% less_trans
thf(fact_41_less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less @ A @ X3 @ Y )
          | ( X3 = Y )
          | ( ord_less @ A @ Y @ X3 ) ) ) ).

% less_linear
thf(fact_42_less__irrefl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A] :
          ~ ( ord_less @ A @ X3 @ X3 ) ) ).

% less_irrefl
thf(fact_43_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A] :
          ( ( A2 = B3 )
         => ( ( ord_less @ A @ B3 @ C2 )
           => ( ord_less @ A @ A2 @ C2 ) ) ) ) ).

% ord_eq_less_trans
thf(fact_44_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( B3 = C2 )
           => ( ord_less @ A @ A2 @ C2 ) ) ) ) ).

% ord_less_eq_trans
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A3: set @ A] :
      ( ( collect @ A
        @ ^ [X4: A] : ( member @ A @ X4 @ A3 ) )
      = A3 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X2: A] :
          ( ( P @ X2 )
          = ( Q @ X2 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F3: A > B,G2: A > B] :
      ( ! [X2: A] :
          ( ( F3 @ X2 )
          = ( G2 @ X2 ) )
     => ( F3 = G2 ) ) ).

% ext
thf(fact_49_dual__order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A] :
          ( ( ord_less @ A @ B3 @ A2 )
         => ~ ( ord_less @ A @ A2 @ B3 ) ) ) ).

% dual_order.asym
thf(fact_50_less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ( X3 != Y ) ) ) ).

% less_imp_not_eq
thf(fact_51_less__not__sym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ~ ( ord_less @ A @ Y @ X3 ) ) ) ).

% less_not_sym
thf(fact_52_less__induct,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,A2: A] :
          ( ! [X2: A] :
              ( ! [Y3: A] :
                  ( ( ord_less @ A @ Y3 @ X2 )
                 => ( P @ Y3 ) )
             => ( P @ X2 ) )
         => ( P @ A2 ) ) ) ).

% less_induct
thf(fact_53_antisym__conv3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y: A,X3: A] :
          ( ~ ( ord_less @ A @ Y @ X3 )
         => ( ( ~ ( ord_less @ A @ X3 @ Y ) )
            = ( X3 = Y ) ) ) ) ).

% antisym_conv3
thf(fact_54_less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ( Y != X3 ) ) ) ).

% less_imp_not_eq2
thf(fact_55_less__imp__triv,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,P: $o] :
          ( ( ord_less @ A @ X3 @ Y )
         => ( ( ord_less @ A @ Y @ X3 )
           => P ) ) ) ).

% less_imp_triv
thf(fact_56_linorder__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ~ ( ord_less @ A @ X3 @ Y )
         => ( ( X3 != Y )
           => ( ord_less @ A @ Y @ X3 ) ) ) ) ).

% linorder_cases
thf(fact_57_dual__order_Oirrefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ~ ( ord_less @ A @ A2 @ A2 ) ) ).

% dual_order.irrefl
thf(fact_58_strict__monoD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F3: A > B,X3: A,Y: A] :
          ( ( order_strict_mono @ A @ B @ F3 )
         => ( ( ord_less @ A @ X3 @ Y )
           => ( ord_less @ B @ ( F3 @ X3 ) @ ( F3 @ Y ) ) ) ) ) ).

% strict_monoD
thf(fact_59_strict__monoI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F3: A > B] :
          ( ! [X2: A,Y2: A] :
              ( ( ord_less @ A @ X2 @ Y2 )
             => ( ord_less @ B @ ( F3 @ X2 ) @ ( F3 @ Y2 ) ) )
         => ( order_strict_mono @ A @ B @ F3 ) ) ) ).

% strict_monoI
thf(fact_60_strict__mono__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ( ( order_strict_mono @ A @ B )
        = ( ^ [F4: A > B] :
            ! [X4: A,Y4: A] :
              ( ( ord_less @ A @ X4 @ Y4 )
             => ( ord_less @ B @ ( F4 @ X4 ) @ ( F4 @ Y4 ) ) ) ) ) ) ).

% strict_mono_def
thf(fact_61_strict__mono__less,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( linorder @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F3: A > B,X3: A,Y: A] :
          ( ( order_strict_mono @ A @ B @ F3 )
         => ( ( ord_less @ B @ ( F3 @ X3 ) @ ( F3 @ Y ) )
            = ( ord_less @ A @ X3 @ Y ) ) ) ) ).

% strict_mono_less
thf(fact_62_x2__nin__l2,axiom,
    ~ ( member @ a @ x2 @ ( set2 @ a @ l2b ) ) ).

% x2_nin_l2
thf(fact_63_x1__nin__l1,axiom,
    ~ ( member @ a @ x1 @ ( set2 @ a @ l1a ) ) ).

% x1_nin_l1
thf(fact_64_ord_Omin__def,axiom,
    ! [A: $tType] :
      ( ( min @ A )
      = ( ^ [Less_eq: A > A > $o,A4: A,B4: A] : ( if @ A @ ( Less_eq @ A4 @ B4 ) @ A4 @ B4 ) ) ) ).

% ord.min_def
thf(fact_65_ord_Omax__def,axiom,
    ! [A: $tType] :
      ( ( max @ A )
      = ( ^ [Less_eq: A > A > $o,A4: A,B4: A] : ( if @ A @ ( Less_eq @ A4 @ B4 ) @ B4 @ A4 ) ) ) ).

% ord.max_def
thf(fact_66_top_Oextremum__strict,axiom,
    ! [A: $tType] :
      ( ( order_top @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ~ ( ord_less @ A @ ( top_top @ A ) @ A2 ) ) ).

% top.extremum_strict
thf(fact_67_top__apply,axiom,
    ! [C: $tType,D: $tType] :
      ( ( top @ C @ ( type2 @ C ) )
     => ( ( top_top @ ( D > C ) )
        = ( ^ [X4: D] : ( top_top @ C ) ) ) ) ).

% top_apply
thf(fact_68_strict__mono__eq,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( linorder @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F3: A > B,X3: A,Y: A] :
          ( ( order_strict_mono @ A @ B @ F3 )
         => ( ( ( F3 @ X3 )
              = ( F3 @ Y ) )
            = ( X3 = Y ) ) ) ) ).

% strict_mono_eq
thf(fact_69_top_Onot__eq__extremum,axiom,
    ! [A: $tType] :
      ( ( order_top @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( A2
           != ( top_top @ A ) )
          = ( ord_less @ A @ A2 @ ( top_top @ A ) ) ) ) ).

% top.not_eq_extremum
thf(fact_70_x2__le,axiom,
    ! [X3: a] :
      ( ( member @ a @ X3 @ ( set2 @ a @ l2b ) )
     => ( ord_less_eq @ a @ x2 @ X3 ) ) ).

% x2_le
thf(fact_71_x1__le,axiom,
    ! [X3: a] :
      ( ( member @ a @ X3 @ ( set2 @ a @ l1a ) )
     => ( ord_less_eq @ a @ x1 @ X3 ) ) ).

% x1_le
thf(fact_72_ind__hyp__l2,axiom,
    ( ( sorted1061247458sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b )
    = ( ord_less_eq @ ( set @ a ) @ ( set2 @ a @ ( cons @ a @ x1 @ l1a ) ) @ ( set2 @ a @ l2b ) ) ) ).

% ind_hyp_l2
thf(fact_73_x2__l2__props,axiom,
    ( ( distinct @ a @ ( cons @ a @ x2 @ l2b ) )
    & ( linorder_sorted @ a @ ( cons @ a @ x2 @ l2b ) ) ) ).

% x2_l2_props
thf(fact_74_x1__l1__props,axiom,
    ( ( distinct @ a @ ( cons @ a @ x1 @ l1a ) )
    & ( linorder_sorted @ a @ ( cons @ a @ x1 @ l1a ) ) ) ).

% x1_l1_props
thf(fact_75_Cons_Ohyps,axiom,
    ( ( ( distinct @ a @ l2b )
      & ( linorder_sorted @ a @ l2b ) )
   => ( ( sorted1061247458sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b )
      = ( ord_less_eq @ ( set @ a ) @ ( set2 @ a @ ( cons @ a @ x1 @ l1a ) ) @ ( set2 @ a @ l2b ) ) ) ) ).

% Cons.hyps
thf(fact_76_strict__mono__less__eq,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( linorder @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F3: A > B,X3: A,Y: A] :
          ( ( order_strict_mono @ A @ B @ F3 )
         => ( ( ord_less_eq @ B @ ( F3 @ X3 ) @ ( F3 @ Y ) )
            = ( ord_less_eq @ A @ X3 @ Y ) ) ) ) ).

% strict_mono_less_eq
thf(fact_77_l2__OK,axiom,
    ( ( distinct @ a @ l2 )
    & ( linorder_sorted @ a @ l2 ) ) ).

% l2_OK
thf(fact_78_l1__OK,axiom,
    ( ( distinct @ a @ l1 )
    & ( linorder_sorted @ a @ l1 ) ) ).

% l1_OK
thf(fact_79_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A] : ( ord_less_eq @ A @ X3 @ X3 ) ) ).

% order_refl
thf(fact_80_l2__props,axiom,
    ( ( distinct @ a @ l2b )
    & ( linorder_sorted @ a @ l2b ) ) ).

% l2_props
thf(fact_81_l1__props,axiom,
    ( ( distinct @ a @ l1a )
    & ( linorder_sorted @ a @ l1a ) ) ).

% l1_props
thf(fact_82_ind__hyp__l1,axiom,
    ! [L2: list @ a] :
      ( ( ( distinct @ a @ L2 )
        & ( linorder_sorted @ a @ L2 ) )
     => ( ( sorted1061247458sorted @ a @ l1a @ L2 )
        = ( ord_less_eq @ ( set @ a ) @ ( set2 @ a @ l1a ) @ ( set2 @ a @ L2 ) ) ) ) ).

% ind_hyp_l1
thf(fact_83_subset__sorted_Osimps_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X13: A,L1: list @ A,X22: A,L2: list @ A] :
          ( ( sorted1061247458sorted @ A @ ( cons @ A @ X13 @ L1 ) @ ( cons @ A @ X22 @ L2 ) )
          = ( ~ ( ord_less @ A @ X13 @ X22 )
            & ( ~ ( ord_less @ A @ X13 @ X22 )
             => ( ( ( X13 = X22 )
                 => ( sorted1061247458sorted @ A @ L1 @ L2 ) )
                & ( ( X13 != X22 )
                 => ( sorted1061247458sorted @ A @ ( cons @ A @ X13 @ L1 ) @ L2 ) ) ) ) ) ) ) ).

% subset_sorted.simps(3)
thf(fact_84_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F3: A > B,G2: A > B,X3: A] :
          ( ( ord_less_eq @ ( A > B ) @ F3 @ G2 )
         => ( ord_less_eq @ B @ ( F3 @ X3 ) @ ( G2 @ X3 ) ) ) ) ).

% le_funD
thf(fact_85_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F3: A > B,G2: A > B,X3: A] :
          ( ( ord_less_eq @ ( A > B ) @ F3 @ G2 )
         => ( ord_less_eq @ B @ ( F3 @ X3 ) @ ( G2 @ X3 ) ) ) ) ).

% le_funE
thf(fact_86_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F3: A > B,G2: A > B] :
          ( ! [X2: A] : ( ord_less_eq @ B @ ( F3 @ X2 ) @ ( G2 @ X2 ) )
         => ( ord_less_eq @ ( A > B ) @ F3 @ G2 ) ) ) ).

% le_funI
thf(fact_87_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less_eq @ ( A > B ) )
        = ( ^ [F4: A > B,G3: A > B] :
            ! [X4: A] : ( ord_less_eq @ B @ ( F4 @ X4 ) @ ( G3 @ X4 ) ) ) ) ) ).

% le_fun_def
thf(fact_88_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F3: B > A,B3: B,C2: B] :
          ( ( ord_less_eq @ A @ A2 @ ( F3 @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C2 )
           => ( ! [X2: B,Y2: B] :
                  ( ( ord_less_eq @ B @ X2 @ Y2 )
                 => ( ord_less_eq @ A @ ( F3 @ X2 ) @ ( F3 @ Y2 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F3 @ C2 ) ) ) ) ) ) ).

% order_subst1
thf(fact_89_order__subst2,axiom,
    ! [A: $tType,C: $tType] :
      ( ( ( order @ C @ ( type2 @ C ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B3: A,F3: A > C,C2: C] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( ord_less_eq @ C @ ( F3 @ B3 ) @ C2 )
           => ( ! [X2: A,Y2: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y2 )
                 => ( ord_less_eq @ C @ ( F3 @ X2 ) @ ( F3 @ Y2 ) ) )
             => ( ord_less_eq @ C @ ( F3 @ A2 ) @ C2 ) ) ) ) ) ).

% order_subst2
thf(fact_90_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F3: B > A,B3: B,C2: B] :
          ( ( A2
            = ( F3 @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C2 )
           => ( ! [X2: B,Y2: B] :
                  ( ( ord_less_eq @ B @ X2 @ Y2 )
                 => ( ord_less_eq @ A @ ( F3 @ X2 ) @ ( F3 @ Y2 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F3 @ C2 ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_91_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B3: A,F3: A > B,C2: B] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( ( F3 @ B3 )
              = C2 )
           => ( ! [X2: A,Y2: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y2 )
                 => ( ord_less_eq @ B @ ( F3 @ X2 ) @ ( F3 @ Y2 ) ) )
             => ( ord_less_eq @ B @ ( F3 @ A2 ) @ C2 ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_92_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y5: A,Z4: A] : ( Y5 = Z4 ) )
        = ( ^ [X4: A,Y4: A] :
              ( ( ord_less_eq @ A @ X4 @ Y4 )
              & ( ord_less_eq @ A @ Y4 @ X4 ) ) ) ) ) ).

% eq_iff
thf(fact_93_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
         => ( ( ord_less_eq @ A @ Y @ X3 )
           => ( X3 = Y ) ) ) ) ).

% antisym
thf(fact_94_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
          | ( ord_less_eq @ A @ Y @ X3 ) ) ) ).

% linear
thf(fact_95_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( X3 = Y )
         => ( ord_less_eq @ A @ X3 @ Y ) ) ) ).

% eq_refl
thf(fact_96_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ~ ( ord_less_eq @ A @ X3 @ Y )
         => ( ord_less_eq @ A @ Y @ X3 ) ) ) ).

% le_cases
thf(fact_97_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ C2 )
           => ( ord_less_eq @ A @ A2 @ C2 ) ) ) ) ).

% order.trans
thf(fact_98_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Z3: A] :
          ( ( ( ord_less_eq @ A @ X3 @ Y )
           => ~ ( ord_less_eq @ A @ Y @ Z3 ) )
         => ( ( ( ord_less_eq @ A @ Y @ X3 )
             => ~ ( ord_less_eq @ A @ X3 @ Z3 ) )
           => ( ( ( ord_less_eq @ A @ X3 @ Z3 )
               => ~ ( ord_less_eq @ A @ Z3 @ Y ) )
             => ( ( ( ord_less_eq @ A @ Z3 @ Y )
                 => ~ ( ord_less_eq @ A @ Y @ X3 ) )
               => ( ( ( ord_less_eq @ A @ Y @ Z3 )
                   => ~ ( ord_less_eq @ A @ Z3 @ X3 ) )
                 => ~ ( ( ord_less_eq @ A @ Z3 @ X3 )
                     => ~ ( ord_less_eq @ A @ X3 @ Y ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_99_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y: A,X3: A] :
          ( ( ord_less_eq @ A @ Y @ X3 )
         => ( ( ord_less_eq @ A @ X3 @ Y )
            = ( X3 = Y ) ) ) ) ).

% antisym_conv
thf(fact_100_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A] :
          ( ( A2 = B3 )
         => ( ( ord_less_eq @ A @ B3 @ C2 )
           => ( ord_less_eq @ A @ A2 @ C2 ) ) ) ) ).

% ord_eq_le_trans
thf(fact_101_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( B3 = C2 )
           => ( ord_less_eq @ A @ A2 @ C2 ) ) ) ) ).

% ord_le_eq_trans
thf(fact_102_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ A2 )
           => ( A2 = B3 ) ) ) ) ).

% order_class.order.antisym
thf(fact_103_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Z3: A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z3 )
           => ( ord_less_eq @ A @ X3 @ Z3 ) ) ) ) ).

% order_trans
thf(fact_104_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ A2 ) ) ).

% dual_order.refl
thf(fact_105_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,A2: A,B3: A] :
          ( ! [A5: A,B2: A] :
              ( ( ord_less_eq @ A @ A5 @ B2 )
             => ( P @ A5 @ B2 ) )
         => ( ! [A5: A,B2: A] :
                ( ( P @ B2 @ A5 )
               => ( P @ A5 @ B2 ) )
           => ( P @ A2 @ B3 ) ) ) ) ).

% linorder_wlog
thf(fact_106_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A,C2: A] :
          ( ( ord_less_eq @ A @ B3 @ A2 )
         => ( ( ord_less_eq @ A @ C2 @ B3 )
           => ( ord_less_eq @ A @ C2 @ A2 ) ) ) ) ).

% dual_order.trans
thf(fact_107_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A] :
          ( ( ord_less_eq @ A @ B3 @ A2 )
         => ( ( ord_less_eq @ A @ A2 @ B3 )
           => ( A2 = B3 ) ) ) ) ).

% dual_order.antisym
thf(fact_108_leD,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y: A,X3: A] :
          ( ( ord_less_eq @ A @ Y @ X3 )
         => ~ ( ord_less @ A @ X3 @ Y ) ) ) ).

% leD
thf(fact_109_leI,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ~ ( ord_less @ A @ X3 @ Y )
         => ( ord_less_eq @ A @ Y @ X3 ) ) ) ).

% leI
thf(fact_110_le__less,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [X4: A,Y4: A] :
              ( ( ord_less @ A @ X4 @ Y4 )
              | ( X4 = Y4 ) ) ) ) ) ).

% le_less
thf(fact_111_less__le,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [X4: A,Y4: A] :
              ( ( ord_less_eq @ A @ X4 @ Y4 )
              & ( X4 != Y4 ) ) ) ) ) ).

% less_le
thf(fact_112_order__le__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F3: B > A,B3: B,C2: B] :
          ( ( ord_less_eq @ A @ A2 @ ( F3 @ B3 ) )
         => ( ( ord_less @ B @ B3 @ C2 )
           => ( ! [X2: B,Y2: B] :
                  ( ( ord_less @ B @ X2 @ Y2 )
                 => ( ord_less @ A @ ( F3 @ X2 ) @ ( F3 @ Y2 ) ) )
             => ( ord_less @ A @ A2 @ ( F3 @ C2 ) ) ) ) ) ) ).

% order_le_less_subst1
thf(fact_113_order__le__less__subst2,axiom,
    ! [A: $tType,C: $tType] :
      ( ( ( order @ C @ ( type2 @ C ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B3: A,F3: A > C,C2: C] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( ord_less @ C @ ( F3 @ B3 ) @ C2 )
           => ( ! [X2: A,Y2: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y2 )
                 => ( ord_less_eq @ C @ ( F3 @ X2 ) @ ( F3 @ Y2 ) ) )
             => ( ord_less @ C @ ( F3 @ A2 ) @ C2 ) ) ) ) ) ).

% order_le_less_subst2
thf(fact_114_order__less__le__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F3: B > A,B3: B,C2: B] :
          ( ( ord_less @ A @ A2 @ ( F3 @ B3 ) )
         => ( ( ord_less_eq @ B @ B3 @ C2 )
           => ( ! [X2: B,Y2: B] :
                  ( ( ord_less_eq @ B @ X2 @ Y2 )
                 => ( ord_less_eq @ A @ ( F3 @ X2 ) @ ( F3 @ Y2 ) ) )
             => ( ord_less @ A @ A2 @ ( F3 @ C2 ) ) ) ) ) ) ).

% order_less_le_subst1
thf(fact_115_order__less__le__subst2,axiom,
    ! [A: $tType,C: $tType] :
      ( ( ( order @ C @ ( type2 @ C ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B3: A,F3: A > C,C2: C] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( ord_less_eq @ C @ ( F3 @ B3 ) @ C2 )
           => ( ! [X2: A,Y2: A] :
                  ( ( ord_less @ A @ X2 @ Y2 )
                 => ( ord_less @ C @ ( F3 @ X2 ) @ ( F3 @ Y2 ) ) )
             => ( ord_less @ C @ ( F3 @ A2 ) @ C2 ) ) ) ) ) ).

% order_less_le_subst2
thf(fact_116_not__le,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ~ ( ord_less_eq @ A @ X3 @ Y ) )
          = ( ord_less @ A @ Y @ X3 ) ) ) ).

% not_le
thf(fact_117_not__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ~ ( ord_less @ A @ X3 @ Y ) )
          = ( ord_less_eq @ A @ Y @ X3 ) ) ) ).

% not_less
thf(fact_118_le__neq__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( A2 != B3 )
           => ( ord_less @ A @ A2 @ B3 ) ) ) ) ).

% le_neq_trans
thf(fact_119_less__imp__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ( ord_less_eq @ A @ X3 @ Y ) ) ) ).

% less_imp_le
thf(fact_120_antisym__conv1,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ~ ( ord_less @ A @ X3 @ Y )
         => ( ( ord_less_eq @ A @ X3 @ Y )
            = ( X3 = Y ) ) ) ) ).

% antisym_conv1
thf(fact_121_antisym__conv2,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
         => ( ( ~ ( ord_less @ A @ X3 @ Y ) )
            = ( X3 = Y ) ) ) ) ).

% antisym_conv2
thf(fact_122_le__less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Z3: A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
         => ( ( ord_less @ A @ Y @ Z3 )
           => ( ord_less @ A @ X3 @ Z3 ) ) ) ) ).

% le_less_trans
thf(fact_123_less__le__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Z3: A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z3 )
           => ( ord_less @ A @ X3 @ Z3 ) ) ) ) ).

% less_le_trans
thf(fact_124_dense__ge,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Z3: A,Y: A] :
          ( ! [X2: A] :
              ( ( ord_less @ A @ Z3 @ X2 )
             => ( ord_less_eq @ A @ Y @ X2 ) )
         => ( ord_less_eq @ A @ Y @ Z3 ) ) ) ).

% dense_ge
thf(fact_125_dense__le,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Y: A,Z3: A] :
          ( ! [X2: A] :
              ( ( ord_less @ A @ X2 @ Y )
             => ( ord_less_eq @ A @ X2 @ Z3 ) )
         => ( ord_less_eq @ A @ Y @ Z3 ) ) ) ).

% dense_le
thf(fact_126_le__less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
          | ( ord_less @ A @ Y @ X3 ) ) ) ).

% le_less_linear
thf(fact_127_le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
         => ( ( ord_less @ A @ X3 @ Y )
            | ( X3 = Y ) ) ) ) ).

% le_imp_less_or_eq
thf(fact_128_less__le__not__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [X4: A,Y4: A] :
              ( ( ord_less_eq @ A @ X4 @ Y4 )
              & ~ ( ord_less_eq @ A @ Y4 @ X4 ) ) ) ) ) ).

% less_le_not_le
thf(fact_129_not__le__imp__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y: A,X3: A] :
          ( ~ ( ord_less_eq @ A @ Y @ X3 )
         => ( ord_less @ A @ X3 @ Y ) ) ) ).

% not_le_imp_less
thf(fact_130_order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A] :
          ( ( ord_less_eq @ A @ A2 @ B3 )
         => ( ( ord_less @ A @ B3 @ C2 )
           => ( ord_less @ A @ A2 @ C2 ) ) ) ) ).

% order.strict_trans1
thf(fact_131_order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ C2 )
           => ( ord_less @ A @ A2 @ C2 ) ) ) ) ).

% order.strict_trans2
thf(fact_132_order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A4: A,B4: A] :
              ( ( ord_less @ A @ A4 @ B4 )
              | ( A4 = B4 ) ) ) ) ) ).

% order.order_iff_strict
thf(fact_133_order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [A4: A,B4: A] :
              ( ( ord_less_eq @ A @ A4 @ B4 )
              & ( A4 != B4 ) ) ) ) ) ).

% order.strict_iff_order
thf(fact_134_dual__order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A,C2: A] :
          ( ( ord_less_eq @ A @ B3 @ A2 )
         => ( ( ord_less @ A @ C2 @ B3 )
           => ( ord_less @ A @ C2 @ A2 ) ) ) ) ).

% dual_order.strict_trans1
thf(fact_135_dual__order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A,C2: A] :
          ( ( ord_less @ A @ B3 @ A2 )
         => ( ( ord_less_eq @ A @ C2 @ B3 )
           => ( ord_less @ A @ C2 @ A2 ) ) ) ) ).

% dual_order.strict_trans2
thf(fact_136_dense__ge__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Z3: A,X3: A,Y: A] :
          ( ( ord_less @ A @ Z3 @ X3 )
         => ( ! [W: A] :
                ( ( ord_less @ A @ Z3 @ W )
               => ( ( ord_less @ A @ W @ X3 )
                 => ( ord_less_eq @ A @ Y @ W ) ) )
           => ( ord_less_eq @ A @ Y @ Z3 ) ) ) ) ).

% dense_ge_bounded
thf(fact_137_dense__le__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Z3: A] :
          ( ( ord_less @ A @ X3 @ Y )
         => ( ! [W: A] :
                ( ( ord_less @ A @ X3 @ W )
               => ( ( ord_less @ A @ W @ Y )
                 => ( ord_less_eq @ A @ W @ Z3 ) ) )
           => ( ord_less_eq @ A @ Y @ Z3 ) ) ) ) ).

% dense_le_bounded
thf(fact_138_order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ord_less_eq @ A @ A2 @ B3 ) ) ) ).

% order.strict_implies_order
thf(fact_139_dual__order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [B4: A,A4: A] :
              ( ( ord_less @ A @ B4 @ A4 )
              | ( A4 = B4 ) ) ) ) ) ).

% dual_order.order_iff_strict
thf(fact_140_dual__order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [B4: A,A4: A] :
              ( ( ord_less_eq @ A @ B4 @ A4 )
              & ( A4 != B4 ) ) ) ) ) ).

% dual_order.strict_iff_order
thf(fact_141_dual__order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A2: A] :
          ( ( ord_less @ A @ B3 @ A2 )
         => ( ord_less_eq @ A @ B3 @ A2 ) ) ) ).

% dual_order.strict_implies_order
thf(fact_142_order_Onot__eq__order__implies__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A] :
          ( ( A2 != B3 )
         => ( ( ord_less_eq @ A @ A2 @ B3 )
           => ( ord_less @ A @ A2 @ B3 ) ) ) ) ).

% order.not_eq_order_implies_strict
thf(fact_143_complete__interval,axiom,
    ! [A: $tType] :
      ( ( condit1037483654norder @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,P: A > $o] :
          ( ( ord_less @ A @ A2 @ B3 )
         => ( ( P @ A2 )
           => ( ~ ( P @ B3 )
             => ? [C3: A] :
                  ( ( ord_less_eq @ A @ A2 @ C3 )
                  & ( ord_less_eq @ A @ C3 @ B3 )
                  & ! [X: A] :
                      ( ( ( ord_less_eq @ A @ A2 @ X )
                        & ( ord_less @ A @ X @ C3 ) )
                     => ( P @ X ) )
                  & ! [D2: A] :
                      ( ! [X2: A] :
                          ( ( ( ord_less_eq @ A @ A2 @ X2 )
                            & ( ord_less @ A @ X2 @ D2 ) )
                         => ( P @ X2 ) )
                     => ( ord_less_eq @ A @ D2 @ C3 ) ) ) ) ) ) ) ).

% complete_interval
thf(fact_144_minf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X: A] :
          ( ( ord_less @ A @ X @ Z )
         => ~ ( ord_less_eq @ A @ T @ X ) ) ) ).

% minf(8)
thf(fact_145_minf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X: A] :
          ( ( ord_less @ A @ X @ Z )
         => ( ord_less_eq @ A @ X @ T ) ) ) ).

% minf(6)
thf(fact_146_pinf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X: A] :
          ( ( ord_less @ A @ Z @ X )
         => ( ord_less_eq @ A @ T @ X ) ) ) ).

% pinf(8)
thf(fact_147_pinf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z: A] :
        ! [X: A] :
          ( ( ord_less @ A @ Z @ X )
         => ~ ( ord_less_eq @ A @ X @ T ) ) ) ).

% pinf(6)
thf(fact_148_top__greatest,axiom,
    ! [A: $tType] :
      ( ( order_top @ A @ ( type2 @ A ) )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ ( top_top @ A ) ) ) ).

% top_greatest
thf(fact_149_top_Oextremum__unique,axiom,
    ! [A: $tType] :
      ( ( order_top @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( top_top @ A ) @ A2 )
          = ( A2
            = ( top_top @ A ) ) ) ) ).

% top.extremum_unique
thf(fact_150_top_Oextremum__uniqueI,axiom,
    ! [A: $tType] :
      ( ( order_top @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ( ( ord_less_eq @ A @ ( top_top @ A ) @ A2 )
         => ( A2
            = ( top_top @ A ) ) ) ) ).

% top.extremum_uniqueI
thf(fact_151_sorted__many__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Zs: list @ A] :
          ( ( linorder_sorted @ A @ ( cons @ A @ X3 @ ( cons @ A @ Y @ Zs ) ) )
          = ( ( ord_less_eq @ A @ X3 @ Y )
            & ( linorder_sorted @ A @ ( cons @ A @ Y @ Zs ) ) ) ) ) ).

% sorted_many_eq
thf(fact_152_sorted_OCons,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,X3: A] :
          ( ! [X2: A] :
              ( ( member @ A @ X2 @ ( set2 @ A @ Xs ) )
             => ( ord_less_eq @ A @ X3 @ X2 ) )
         => ( ( linorder_sorted @ A @ Xs )
           => ( linorder_sorted @ A @ ( cons @ A @ X3 @ Xs ) ) ) ) ) ).

% sorted.Cons
thf(fact_153_sorted__Cons,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Xs: list @ A] :
          ( ( linorder_sorted @ A @ ( cons @ A @ X3 @ Xs ) )
          = ( ( linorder_sorted @ A @ Xs )
            & ! [X4: A] :
                ( ( member @ A @ X4 @ ( set2 @ A @ Xs ) )
               => ( ord_less_eq @ A @ X3 @ X4 ) ) ) ) ) ).

% sorted_Cons
thf(fact_154_sorted__distinct__set__unique,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Ys: list @ A] :
          ( ( linorder_sorted @ A @ Xs )
         => ( ( distinct @ A @ Xs )
           => ( ( linorder_sorted @ A @ Ys )
             => ( ( distinct @ A @ Ys )
               => ( ( ( set2 @ A @ Xs )
                    = ( set2 @ A @ Ys ) )
                 => ( Xs = Ys ) ) ) ) ) ) ) ).

% sorted_distinct_set_unique
thf(fact_155_distinct_Osimps_I2_J,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ X3 @ Xs ) )
      = ( ~ ( member @ A @ X3 @ ( set2 @ A @ Xs ) )
        & ( distinct @ A @ Xs ) ) ) ).

% distinct.simps(2)
thf(fact_156_sorted__many,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A,Y: A,Zs: list @ A] :
          ( ( ord_less_eq @ A @ X3 @ Y )
         => ( ( linorder_sorted @ A @ ( cons @ A @ Y @ Zs ) )
           => ( linorder_sorted @ A @ ( cons @ A @ X3 @ ( cons @ A @ Y @ Zs ) ) ) ) ) ) ).

% sorted_many
thf(fact_157_list_Oinject,axiom,
    ! [A: $tType,X21: A,X222: list @ A,Y21: A,Y22: list @ A] :
      ( ( ( cons @ A @ X21 @ X222 )
        = ( cons @ A @ Y21 @ Y22 ) )
      = ( ( X21 = Y21 )
        & ( X222 = Y22 ) ) ) ).

% list.inject
thf(fact_158_less__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less @ ( A > B ) )
        = ( ^ [F4: A > B,G3: A > B] :
              ( ( ord_less_eq @ ( A > B ) @ F4 @ G3 )
              & ~ ( ord_less_eq @ ( A > B ) @ G3 @ F4 ) ) ) ) ) ).

% less_fun_def
thf(fact_159_not__Cons__self2,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( cons @ A @ X3 @ Xs )
     != Xs ) ).

% not_Cons_self2
thf(fact_160_list_Oset__cases,axiom,
    ! [A: $tType,E: A,A2: list @ A] :
      ( ( member @ A @ E @ ( set2 @ A @ A2 ) )
     => ( ! [Z22: list @ A] :
            ( A2
           != ( cons @ A @ E @ Z22 ) )
       => ~ ! [Z1: A,Z22: list @ A] :
              ( ( A2
                = ( cons @ A @ Z1 @ Z22 ) )
             => ~ ( member @ A @ E @ ( set2 @ A @ Z22 ) ) ) ) ) ).

% list.set_cases
thf(fact_161_set__ConsD,axiom,
    ! [A: $tType,Y: A,X3: A,Xs: list @ A] :
      ( ( member @ A @ Y @ ( set2 @ A @ ( cons @ A @ X3 @ Xs ) ) )
     => ( ( Y = X3 )
        | ( member @ A @ Y @ ( set2 @ A @ Xs ) ) ) ) ).

% set_ConsD
thf(fact_162_list_Oset__intros_I1_J,axiom,
    ! [A: $tType,A1: A,A22: list @ A] : ( member @ A @ A1 @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ).

% list.set_intros(1)
thf(fact_163_list_Oset__intros_I2_J,axiom,
    ! [A: $tType,X3: A,A22: list @ A,A1: A] :
      ( ( member @ A @ X3 @ ( set2 @ A @ A22 ) )
     => ( member @ A @ X3 @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ) ).

% list.set_intros(2)
thf(fact_164_subset__code_I1_J,axiom,
    ! [A: $tType,Xs: list @ A,B5: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ B5 )
      = ( ! [X4: A] :
            ( ( member @ A @ X4 @ ( set2 @ A @ Xs ) )
           => ( member @ A @ X4 @ B5 ) ) ) ) ).

% subset_code(1)
thf(fact_165_distinct__length__2__or__more,axiom,
    ! [A: $tType,A2: A,B3: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ A2 @ ( cons @ A @ B3 @ Xs ) ) )
      = ( ( A2 != B3 )
        & ( distinct @ A @ ( cons @ A @ A2 @ Xs ) )
        & ( distinct @ A @ ( cons @ A @ B3 @ Xs ) ) ) ) ).

% distinct_length_2_or_more
thf(fact_166_set__subset__Cons,axiom,
    ! [A: $tType,Xs: list @ A,X3: A] : ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ ( set2 @ A @ ( cons @ A @ X3 @ Xs ) ) ) ).

% set_subset_Cons
thf(fact_167_subsetI,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A] :
      ( ! [X2: A] :
          ( ( member @ A @ X2 @ A3 )
         => ( member @ A @ X2 @ B5 ) )
     => ( ord_less_eq @ ( set @ A ) @ A3 @ B5 ) ) ).

% subsetI
thf(fact_168_subset__antisym,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B5 )
     => ( ( ord_less_eq @ ( set @ A ) @ B5 @ A3 )
       => ( A3 = B5 ) ) ) ).

% subset_antisym
thf(fact_169_psubsetI,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B5 )
     => ( ( A3 != B5 )
       => ( ord_less @ ( set @ A ) @ A3 @ B5 ) ) ) ).

% psubsetI
thf(fact_170_subset__UNIV,axiom,
    ! [A: $tType,A3: set @ A] : ( ord_less_eq @ ( set @ A ) @ A3 @ ( top_top @ ( set @ A ) ) ) ).

% subset_UNIV
thf(fact_171_psubsetE,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A3 @ B5 )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A3 @ B5 )
         => ( ord_less_eq @ ( set @ A ) @ B5 @ A3 ) ) ) ).

% psubsetE
thf(fact_172_psubset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less @ ( set @ A ) )
      = ( ^ [A6: set @ A,B6: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
            & ( A6 != B6 ) ) ) ) ).

% psubset_eq
thf(fact_173_psubset__imp__subset,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A3 @ B5 )
     => ( ord_less_eq @ ( set @ A ) @ A3 @ B5 ) ) ).

% psubset_imp_subset
thf(fact_174_psubset__subset__trans,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A,C4: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A3 @ B5 )
     => ( ( ord_less_eq @ ( set @ A ) @ B5 @ C4 )
       => ( ord_less @ ( set @ A ) @ A3 @ C4 ) ) ) ).

% psubset_subset_trans
thf(fact_175_subset__not__subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less @ ( set @ A ) )
      = ( ^ [A6: set @ A,B6: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
            & ~ ( ord_less_eq @ ( set @ A ) @ B6 @ A6 ) ) ) ) ).

% subset_not_subset_eq
thf(fact_176_subset__psubset__trans,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A,C4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B5 )
     => ( ( ord_less @ ( set @ A ) @ B5 @ C4 )
       => ( ord_less @ ( set @ A ) @ A3 @ C4 ) ) ) ).

% subset_psubset_trans
thf(fact_177_subset__iff__psubset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A6: set @ A,B6: set @ A] :
            ( ( ord_less @ ( set @ A ) @ A6 @ B6 )
            | ( A6 = B6 ) ) ) ) ).

% subset_iff_psubset_eq
thf(fact_178_Collect__mono__iff,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) )
      = ( ! [X4: A] :
            ( ( P @ X4 )
           => ( Q @ X4 ) ) ) ) ).

% Collect_mono_iff
thf(fact_179_contra__subsetD,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A,C2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B5 )
     => ( ~ ( member @ A @ C2 @ B5 )
       => ~ ( member @ A @ C2 @ A3 ) ) ) ).

% contra_subsetD
thf(fact_180_set__eq__subset,axiom,
    ! [A: $tType] :
      ( ( ^ [Y5: set @ A,Z4: set @ A] : ( Y5 = Z4 ) )
      = ( ^ [A6: set @ A,B6: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A6 @ B6 )
            & ( ord_less_eq @ ( set @ A ) @ B6 @ A6 ) ) ) ) ).

% set_eq_subset
thf(fact_181_subset__trans,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A,C4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B5 )
     => ( ( ord_less_eq @ ( set @ A ) @ B5 @ C4 )
       => ( ord_less_eq @ ( set @ A ) @ A3 @ C4 ) ) ) ).

% subset_trans
thf(fact_182_Collect__mono,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X2: A] :
          ( ( P @ X2 )
         => ( Q @ X2 ) )
     => ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) ) ) ).

% Collect_mono
thf(fact_183_subset__refl,axiom,
    ! [A: $tType,A3: set @ A] : ( ord_less_eq @ ( set @ A ) @ A3 @ A3 ) ).

% subset_refl
thf(fact_184_rev__subsetD,axiom,
    ! [A: $tType,C2: A,A3: set @ A,B5: set @ A] :
      ( ( member @ A @ C2 @ A3 )
     => ( ( ord_less_eq @ ( set @ A ) @ A3 @ B5 )
       => ( member @ A @ C2 @ B5 ) ) ) ).

% rev_subsetD
thf(fact_185_subset__iff,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A6: set @ A,B6: set @ A] :
          ! [T2: A] :
            ( ( member @ A @ T2 @ A6 )
           => ( member @ A @ T2 @ B6 ) ) ) ) ).

% subset_iff
thf(fact_186_set__rev__mp,axiom,
    ! [A: $tType,X3: A,A3: set @ A,B5: set @ A] :
      ( ( member @ A @ X3 @ A3 )
     => ( ( ord_less_eq @ ( set @ A ) @ A3 @ B5 )
       => ( member @ A @ X3 @ B5 ) ) ) ).

% set_rev_mp
thf(fact_187_equalityD2,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A] :
      ( ( A3 = B5 )
     => ( ord_less_eq @ ( set @ A ) @ B5 @ A3 ) ) ).

% equalityD2
thf(fact_188_equalityD1,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A] :
      ( ( A3 = B5 )
     => ( ord_less_eq @ ( set @ A ) @ A3 @ B5 ) ) ).

% equalityD1
thf(fact_189_subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A6: set @ A,B6: set @ A] :
          ! [X4: A] :
            ( ( member @ A @ X4 @ A6 )
           => ( member @ A @ X4 @ B6 ) ) ) ) ).

% subset_eq
thf(fact_190_equalityE,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A] :
      ( ( A3 = B5 )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A3 @ B5 )
         => ~ ( ord_less_eq @ ( set @ A ) @ B5 @ A3 ) ) ) ).

% equalityE
thf(fact_191_subsetCE,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A,C2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B5 )
     => ( ( member @ A @ C2 @ A3 )
       => ( member @ A @ C2 @ B5 ) ) ) ).

% subsetCE
thf(fact_192_subsetD,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A,C2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B5 )
     => ( ( member @ A @ C2 @ A3 )
       => ( member @ A @ C2 @ B5 ) ) ) ).

% subsetD
thf(fact_193_in__mono,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A,X3: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B5 )
     => ( ( member @ A @ X3 @ A3 )
       => ( member @ A @ X3 @ B5 ) ) ) ).

% in_mono
thf(fact_194_set__mp,axiom,
    ! [A: $tType,A3: set @ A,B5: set @ A,X3: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A3 @ B5 )
     => ( ( member @ A @ X3 @ A3 )
       => ( member @ A @ X3 @ B5 ) ) ) ).

% set_mp
thf(fact_195_distinct__union,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( distinct @ A @ ( union @ A @ Xs @ Ys ) )
      = ( distinct @ A @ Ys ) ) ).

% distinct_union
thf(fact_196_top_Oordering__top__axioms,axiom,
    ! [A: $tType] :
      ( ( order_top @ A @ ( type2 @ A ) )
     => ( ordering_top @ A @ ( ord_less_eq @ A ) @ ( ord_less @ A ) @ ( top_top @ A ) ) ) ).

% top.ordering_top_axioms
thf(fact_197_not__in__set__insert,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ~ ( member @ A @ X3 @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X3 @ Xs )
        = ( cons @ A @ X3 @ Xs ) ) ) ).

% not_in_set_insert
thf(fact_198_in__set__insert,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( member @ A @ X3 @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X3 @ Xs )
        = Xs ) ) ).

% in_set_insert
thf(fact_199_distinct__insert,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( distinct @ A @ ( insert @ A @ X3 @ Xs ) )
      = ( distinct @ A @ Xs ) ) ).

% distinct_insert
thf(fact_200_ordering__top_Oextremum__uniqueI,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less: A > A > $o,Top: A,A2: A] :
      ( ( ordering_top @ A @ Less_eq2 @ Less @ Top )
     => ( ( Less_eq2 @ Top @ A2 )
       => ( A2 = Top ) ) ) ).

% ordering_top.extremum_uniqueI
thf(fact_201_ordering__top_Onot__eq__extremum,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less: A > A > $o,Top: A,A2: A] :
      ( ( ordering_top @ A @ Less_eq2 @ Less @ Top )
     => ( ( A2 != Top )
        = ( Less @ A2 @ Top ) ) ) ).

% ordering_top.not_eq_extremum
thf(fact_202_ordering__top_Oextremum__unique,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less: A > A > $o,Top: A,A2: A] :
      ( ( ordering_top @ A @ Less_eq2 @ Less @ Top )
     => ( ( Less_eq2 @ Top @ A2 )
        = ( A2 = Top ) ) ) ).

% ordering_top.extremum_unique
thf(fact_203_ordering__top_Oextremum__strict,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less: A > A > $o,Top: A,A2: A] :
      ( ( ordering_top @ A @ Less_eq2 @ Less @ Top )
     => ~ ( Less @ Top @ A2 ) ) ).

% ordering_top.extremum_strict
thf(fact_204_ordering__top_Oextremum,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less: A > A > $o,Top: A,A2: A] :
      ( ( ordering_top @ A @ Less_eq2 @ Less @ Top )
     => ( Less_eq2 @ A2 @ Top ) ) ).

% ordering_top.extremum
thf(fact_205_List_Oinsert__def,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [X4: A,Xs2: list @ A] : ( if @ ( list @ A ) @ ( member @ A @ X4 @ ( set2 @ A @ Xs2 ) ) @ Xs2 @ ( cons @ A @ X4 @ Xs2 ) ) ) ) ).

% List.insert_def
thf(fact_206_sorted_Oinducts,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: list @ A,P: ( list @ A ) > $o] :
          ( ( linorder_sorted @ A @ X3 )
         => ( ( P @ ( nil @ A ) )
           => ( ! [Xs3: list @ A,X2: A] :
                  ( ! [Xa: A] :
                      ( ( member @ A @ Xa @ ( set2 @ A @ Xs3 ) )
                     => ( ord_less_eq @ A @ X2 @ Xa ) )
                 => ( ( linorder_sorted @ A @ Xs3 )
                   => ( ( P @ Xs3 )
                     => ( P @ ( cons @ A @ X2 @ Xs3 ) ) ) ) )
             => ( P @ X3 ) ) ) ) ) ).

% sorted.inducts
thf(fact_207_sorted_Osimps,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ( linorder_sorted @ A )
        = ( ^ [A4: list @ A] :
              ( ( A4
                = ( nil @ A ) )
              | ? [Xs2: list @ A,X4: A] :
                  ( ( A4
                    = ( cons @ A @ X4 @ Xs2 ) )
                  & ! [Y4: A] :
                      ( ( member @ A @ Y4 @ ( set2 @ A @ Xs2 ) )
                     => ( ord_less_eq @ A @ X4 @ Y4 ) )
                  & ( linorder_sorted @ A @ Xs2 ) ) ) ) ) ) ).

% sorted.simps
thf(fact_208_sorted__single,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: A] : ( linorder_sorted @ A @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ) ).

% sorted_single
thf(fact_209_insert__Nil,axiom,
    ! [A: $tType,X3: A] :
      ( ( insert @ A @ X3 @ ( nil @ A ) )
      = ( cons @ A @ X3 @ ( nil @ A ) ) ) ).

% insert_Nil
thf(fact_210_inter__sorted_Oinduct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
          ( ! [X1: list @ A] : ( P @ ( nil @ A ) @ X1 )
         => ( ! [V: A,Va: list @ A] : ( P @ ( cons @ A @ V @ Va ) @ ( nil @ A ) )
           => ( ! [X1: A,L12: list @ A,X23: A,L22: list @ A] :
                  ( ( ( ord_less @ A @ X1 @ X23 )
                   => ( P @ L12 @ ( cons @ A @ X23 @ L22 ) ) )
                 => ( ( ~ ( ord_less @ A @ X1 @ X23 )
                     => ( ( X1 = X23 )
                       => ( P @ L12 @ L22 ) ) )
                   => ( ( ~ ( ord_less @ A @ X1 @ X23 )
                       => ( ( X1 != X23 )
                         => ( P @ ( cons @ A @ X1 @ L12 ) @ L22 ) ) )
                     => ( P @ ( cons @ A @ X1 @ L12 ) @ ( cons @ A @ X23 @ L22 ) ) ) ) )
             => ( P @ A0 @ A1 ) ) ) ) ) ).

% inter_sorted.induct
thf(fact_211_subset__sorted_Oinduct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
          ( ! [X1: list @ A] : ( P @ ( nil @ A ) @ X1 )
         => ( ! [X1: A,L12: list @ A] : ( P @ ( cons @ A @ X1 @ L12 ) @ ( nil @ A ) )
           => ( ! [X1: A,L12: list @ A,X23: A,L22: list @ A] :
                  ( ( ~ ( ord_less @ A @ X1 @ X23 )
                   => ( ( X1 = X23 )
                     => ( P @ L12 @ L22 ) ) )
                 => ( ( ~ ( ord_less @ A @ X1 @ X23 )
                     => ( ( X1 != X23 )
                       => ( P @ ( cons @ A @ X1 @ L12 ) @ L22 ) ) )
                   => ( P @ ( cons @ A @ X1 @ L12 ) @ ( cons @ A @ X23 @ L22 ) ) ) )
             => ( P @ A0 @ A1 ) ) ) ) ) ).

% subset_sorted.induct
thf(fact_212_distinct__singleton,axiom,
    ! [A: $tType,X3: A] : ( distinct @ A @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ).

% distinct_singleton
thf(fact_213_sorted_ONil,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( linorder_sorted @ A @ ( nil @ A ) ) ) ).

% sorted.Nil
thf(fact_214_map__tailrec__rev_Oinduct,axiom,
    ! [A: $tType,B: $tType,P: ( A > B ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B,A1: list @ A,A22: list @ B] :
      ( ! [F2: A > B,X1: list @ B] : ( P @ F2 @ ( nil @ A ) @ X1 )
     => ( ! [F2: A > B,A5: A,As: list @ A,Bs: list @ B] :
            ( ( P @ F2 @ As @ ( cons @ B @ ( F2 @ A5 ) @ Bs ) )
           => ( P @ F2 @ ( cons @ A @ A5 @ As ) @ Bs ) )
       => ( P @ A0 @ A1 @ A22 ) ) ) ).

% map_tailrec_rev.induct
thf(fact_215_list__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X2: A] : ( P @ ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ( ! [X2: A,Xs3: list @ A] :
              ( ( Xs3
               != ( nil @ A ) )
             => ( ( P @ Xs3 )
               => ( P @ ( cons @ A @ X2 @ Xs3 ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% list_nonempty_induct
thf(fact_216_remdups__adj_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,A0: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X2: A] : ( P @ ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ( ! [X2: A,Y2: A,Xs3: list @ A] :
              ( ( ( X2 = Y2 )
               => ( P @ ( cons @ A @ X2 @ Xs3 ) ) )
             => ( ( ( X2 != Y2 )
                 => ( P @ ( cons @ A @ Y2 @ Xs3 ) ) )
               => ( P @ ( cons @ A @ X2 @ ( cons @ A @ Y2 @ Xs3 ) ) ) ) )
         => ( P @ A0 ) ) ) ) ).

% remdups_adj.induct
thf(fact_217_remdups__adj_Ocases,axiom,
    ! [A: $tType,X3: list @ A] :
      ( ( X3
       != ( nil @ A ) )
     => ( ! [X2: A] :
            ( X3
           != ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ~ ! [X2: A,Y2: A,Xs3: list @ A] :
              ( X3
             != ( cons @ A @ X2 @ ( cons @ A @ Y2 @ Xs3 ) ) ) ) ) ).

% remdups_adj.cases
thf(fact_218_transpose_Ocases,axiom,
    ! [A: $tType,X3: list @ ( list @ A )] :
      ( ( X3
       != ( nil @ ( list @ A ) ) )
     => ( ! [Xss: list @ ( list @ A )] :
            ( X3
           != ( cons @ ( list @ A ) @ ( nil @ A ) @ Xss ) )
       => ~ ! [X2: A,Xs3: list @ A,Xss: list @ ( list @ A )] :
              ( X3
             != ( cons @ ( list @ A ) @ ( cons @ A @ X2 @ Xs3 ) @ Xss ) ) ) ) ).

% transpose.cases
thf(fact_219_splice_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X1: list @ A] : ( P @ ( nil @ A ) @ X1 )
     => ( ! [V: A,Va: list @ A] : ( P @ ( cons @ A @ V @ Va ) @ ( nil @ A ) )
       => ( ! [X2: A,Xs3: list @ A,Y2: A,Ys2: list @ A] :
              ( ( P @ Xs3 @ Ys2 )
             => ( P @ ( cons @ A @ X2 @ Xs3 ) @ ( cons @ A @ Y2 @ Ys2 ) ) )
         => ( P @ A0 @ A1 ) ) ) ) ).

% splice.induct
thf(fact_220_list__induct2_H,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,Xs: list @ A,Ys: list @ B] :
      ( ( P @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [X2: A,Xs3: list @ A] : ( P @ ( cons @ A @ X2 @ Xs3 ) @ ( nil @ B ) )
       => ( ! [Y2: B,Ys2: list @ B] : ( P @ ( nil @ A ) @ ( cons @ B @ Y2 @ Ys2 ) )
         => ( ! [X2: A,Xs3: list @ A,Y2: B,Ys2: list @ B] :
                ( ( P @ Xs3 @ Ys2 )
               => ( P @ ( cons @ A @ X2 @ Xs3 ) @ ( cons @ B @ Y2 @ Ys2 ) ) )
           => ( P @ Xs @ Ys ) ) ) ) ) ).

% list_induct2'
thf(fact_221_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
      = ( ? [Y4: A,Ys3: list @ A] :
            ( Xs
            = ( cons @ A @ Y4 @ Ys3 ) ) ) ) ).

% neq_Nil_conv
thf(fact_222_list_Oinducts,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,List: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X1: A,X23: list @ A] :
            ( ( P @ X23 )
           => ( P @ ( cons @ A @ X1 @ X23 ) ) )
       => ( P @ List ) ) ) ).

% list.inducts
thf(fact_223_list_Oexhaust,axiom,
    ! [A: $tType,Y: list @ A] :
      ( ( Y
       != ( nil @ A ) )
     => ~ ! [X212: A,X223: list @ A] :
            ( Y
           != ( cons @ A @ X212 @ X223 ) ) ) ).

% list.exhaust
thf(fact_224_list_OdiscI,axiom,
    ! [A: $tType,List: list @ A,X21: A,X222: list @ A] :
      ( ( List
        = ( cons @ A @ X21 @ X222 ) )
     => ( List
       != ( nil @ A ) ) ) ).

% list.discI
thf(fact_225_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : ( distinct @ A @ ( nil @ A ) ) ).

% distinct.simps(1)
thf(fact_226_list_Odistinct_I1_J,axiom,
    ! [A: $tType,X21: A,X222: list @ A] :
      ( ( nil @ A )
     != ( cons @ A @ X21 @ X222 ) ) ).

% list.distinct(1)
thf(fact_227_subset__sorted_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L2: list @ A] : ( sorted1061247458sorted @ A @ ( nil @ A ) @ L2 ) ) ).

% subset_sorted.simps(1)
thf(fact_228_subset__sorted_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X13: A,L1: list @ A] :
          ~ ( sorted1061247458sorted @ A @ ( cons @ A @ X13 @ L1 ) @ ( nil @ A ) ) ) ).

% subset_sorted.simps(2)
thf(fact_229_subset__sorted_Oelims_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: list @ A,Xa2: list @ A] :
          ( ~ ( sorted1061247458sorted @ A @ X3 @ Xa2 )
         => ( ( ? [X1: A,L12: list @ A] :
                  ( X3
                  = ( cons @ A @ X1 @ L12 ) )
             => ( Xa2
               != ( nil @ A ) ) )
           => ~ ! [X1: A,L12: list @ A] :
                  ( ( X3
                    = ( cons @ A @ X1 @ L12 ) )
                 => ! [X23: A,L22: list @ A] :
                      ( ( Xa2
                        = ( cons @ A @ X23 @ L22 ) )
                     => ( ~ ( ord_less @ A @ X1 @ X23 )
                        & ( ~ ( ord_less @ A @ X1 @ X23 )
                         => ( ( ( X1 = X23 )
                             => ( sorted1061247458sorted @ A @ L12 @ L22 ) )
                            & ( ( X1 != X23 )
                             => ( sorted1061247458sorted @ A @ ( cons @ A @ X1 @ L12 ) @ L22 ) ) ) ) ) ) ) ) ) ) ).

% subset_sorted.elims(3)
thf(fact_230_subset__sorted_Oelims_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: list @ A,Xa2: list @ A] :
          ( ( sorted1061247458sorted @ A @ X3 @ Xa2 )
         => ( ( ( X3
                = ( nil @ A ) )
             => ! [L22: list @ A] : ( Xa2 != L22 ) )
           => ~ ! [X1: A,L12: list @ A] :
                  ( ( X3
                    = ( cons @ A @ X1 @ L12 ) )
                 => ! [X23: A,L22: list @ A] :
                      ( ( Xa2
                        = ( cons @ A @ X23 @ L22 ) )
                     => ~ ( ~ ( ord_less @ A @ X1 @ X23 )
                          & ( ~ ( ord_less @ A @ X1 @ X23 )
                           => ( ( ( X1 = X23 )
                               => ( sorted1061247458sorted @ A @ L12 @ L22 ) )
                              & ( ( X1 != X23 )
                               => ( sorted1061247458sorted @ A @ ( cons @ A @ X1 @ L12 ) @ L22 ) ) ) ) ) ) ) ) ) ) ).

% subset_sorted.elims(2)
thf(fact_231_subset__sorted_Oelims_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: list @ A,Xa2: list @ A,Y: $o] :
          ( ( ( sorted1061247458sorted @ A @ X3 @ Xa2 )
            = Y )
         => ( ( ( X3
                = ( nil @ A ) )
             => ~ Y )
           => ( ( ? [X1: A,L12: list @ A] :
                    ( X3
                    = ( cons @ A @ X1 @ L12 ) )
               => ( ( Xa2
                    = ( nil @ A ) )
                 => Y ) )
             => ~ ! [X1: A,L12: list @ A] :
                    ( ( X3
                      = ( cons @ A @ X1 @ L12 ) )
                   => ! [X23: A,L22: list @ A] :
                        ( ( Xa2
                          = ( cons @ A @ X23 @ L22 ) )
                       => ( Y
                          = ( ~ ( ~ ( ord_less @ A @ X1 @ X23 )
                                & ( ~ ( ord_less @ A @ X1 @ X23 )
                                 => ( ( ( X1 = X23 )
                                     => ( sorted1061247458sorted @ A @ L12 @ L22 ) )
                                    & ( ( X1 != X23 )
                                     => ( sorted1061247458sorted @ A @ ( cons @ A @ X1 @ L12 ) @ L22 ) ) ) ) ) ) ) ) ) ) ) ) ) ).

% subset_sorted.elims(1)
thf(fact_232_sorted_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A2: list @ A] :
          ( ( linorder_sorted @ A @ A2 )
         => ( ( A2
             != ( nil @ A ) )
           => ~ ! [Xs3: list @ A,X2: A] :
                  ( ( A2
                    = ( cons @ A @ X2 @ Xs3 ) )
                 => ( ! [Xa: A] :
                        ( ( member @ A @ Xa @ ( set2 @ A @ Xs3 ) )
                       => ( ord_less_eq @ A @ X2 @ Xa ) )
                   => ~ ( linorder_sorted @ A @ Xs3 ) ) ) ) ) ) ).

% sorted.cases
thf(fact_233_the__elem__set,axiom,
    ! [A: $tType,X3: A] :
      ( ( the_elem @ A @ ( set2 @ A @ ( cons @ A @ X3 @ ( nil @ A ) ) ) )
      = X3 ) ).

% the_elem_set
thf(fact_234_quicksort_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X3: list @ A] :
          ( ( X3
           != ( nil @ A ) )
         => ~ ! [X2: A,Xs3: list @ A] :
                ( X3
               != ( cons @ A @ X2 @ Xs3 ) ) ) ) ).

% quicksort.cases
thf(fact_235_sublists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( sublists @ A @ ( nil @ A ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% sublists.simps(1)
thf(fact_236_revg_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X1: list @ A] : ( P @ ( nil @ A ) @ X1 )
     => ( ! [A5: A,As: list @ A,B2: list @ A] :
            ( ( P @ As @ ( cons @ A @ A5 @ B2 ) )
           => ( P @ ( cons @ A @ A5 @ As ) @ B2 ) )
       => ( P @ A0 @ A1 ) ) ) ).

% revg.induct
thf(fact_237_ord__eq__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B3: A,C2: A,D3: A] :
          ( ( A2 = B3 )
         => ( ( ord_less_eq @ A @ B3 @ C2 )
           => ( ( C2 = D3 )
             => ( ord_less_eq @ A @ A2 @ D3 ) ) ) ) ) ).

% ord_eq_le_eq_trans
thf(fact_238_list__tail__coinc,axiom,
    ! [A: $tType,N1: A,R1: list @ A,N2: A,R2: list @ A] :
      ( ( ( cons @ A @ N1 @ R1 )
        = ( cons @ A @ N2 @ R2 ) )
     => ( ( N1 = N2 )
        & ( R1 = R2 ) ) ) ).

% list_tail_coinc
thf(fact_239_subset__Collect__conv,axiom,
    ! [A: $tType,S: set @ A,P: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ S @ ( collect @ A @ P ) )
      = ( ! [X4: A] :
            ( ( member @ A @ X4 @ S )
           => ( P @ X4 ) ) ) ) ).

% subset_Collect_conv
thf(fact_240_mergesort__by__rel__merge__induct,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,R3: A > B > $o,Xs: list @ A,Ys: list @ B] :
      ( ! [Xs3: list @ A] : ( P @ Xs3 @ ( nil @ B ) )
     => ( ! [X1: list @ B] : ( P @ ( nil @ A ) @ X1 )
       => ( ! [X2: A,Xs3: list @ A,Y2: B,Ys2: list @ B] :
              ( ( R3 @ X2 @ Y2 )
             => ( ( P @ Xs3 @ ( cons @ B @ Y2 @ Ys2 ) )
               => ( P @ ( cons @ A @ X2 @ Xs3 ) @ ( cons @ B @ Y2 @ Ys2 ) ) ) )
         => ( ! [X2: A,Xs3: list @ A,Y2: B,Ys2: list @ B] :
                ( ~ ( R3 @ X2 @ Y2 )
               => ( ( P @ ( cons @ A @ X2 @ Xs3 ) @ Ys2 )
                 => ( P @ ( cons @ A @ X2 @ Xs3 ) @ ( cons @ B @ Y2 @ Ys2 ) ) ) )
           => ( P @ Xs @ Ys ) ) ) ) ) ).

% mergesort_by_rel_merge_induct
thf(fact_241_mergesort__by__rel__merge_Oinduct,axiom,
    ! [A: $tType,P: ( A > A > $o ) > ( list @ A ) > ( list @ A ) > $o,A0: A > A > $o,A1: list @ A,A22: list @ A] :
      ( ! [R4: A > A > $o,X2: A,Xs3: list @ A,Y2: A,Ys2: list @ A] :
          ( ( ( R4 @ X2 @ Y2 )
           => ( P @ R4 @ Xs3 @ ( cons @ A @ Y2 @ Ys2 ) ) )
         => ( ( ~ ( R4 @ X2 @ Y2 )
             => ( P @ R4 @ ( cons @ A @ X2 @ Xs3 ) @ Ys2 ) )
           => ( P @ R4 @ ( cons @ A @ X2 @ Xs3 ) @ ( cons @ A @ Y2 @ Ys2 ) ) ) )
     => ( ! [R4: A > A > $o,Xs3: list @ A] : ( P @ R4 @ Xs3 @ ( nil @ A ) )
       => ( ! [R4: A > A > $o,V: A,Va: list @ A] : ( P @ R4 @ ( nil @ A ) @ ( cons @ A @ V @ Va ) )
         => ( P @ A0 @ A1 @ A22 ) ) ) ) ).

% mergesort_by_rel_merge.induct
thf(fact_242_list__all__zip_Oinduct,axiom,
    ! [A: $tType,B: $tType,P: ( A > B > $o ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B > $o,A1: list @ A,A22: list @ B] :
      ( ! [P3: A > B > $o] : ( P @ P3 @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [P3: A > B > $o,A5: A,As: list @ A,B2: B,Bs: list @ B] :
            ( ( P @ P3 @ As @ Bs )
           => ( P @ P3 @ ( cons @ A @ A5 @ As ) @ ( cons @ B @ B2 @ Bs ) ) )
       => ( ! [P3: A > B > $o,V: A,Va: list @ A] : ( P @ P3 @ ( cons @ A @ V @ Va ) @ ( nil @ B ) )
         => ( ! [P3: A > B > $o,V: B,Va: list @ B] : ( P @ P3 @ ( nil @ A ) @ ( cons @ B @ V @ Va ) )
           => ( P @ A0 @ A1 @ A22 ) ) ) ) ) ).

% list_all_zip.induct
thf(fact_243_list__induct__first2,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X2: A] : ( P @ ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ( ! [X1: A,X23: A,Xs3: list @ A] :
              ( ( P @ Xs3 )
             => ( P @ ( cons @ A @ X1 @ ( cons @ A @ X23 @ Xs3 ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% list_induct_first2
thf(fact_244_list__2pre__induct,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,W1: list @ A,W2: list @ B] :
      ( ( P @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [E2: A,W12: list @ A,W22: list @ B] :
            ( ( P @ W12 @ W22 )
           => ( P @ ( cons @ A @ E2 @ W12 ) @ W22 ) )
       => ( ! [E2: B,W13: list @ A,W23: list @ B] :
              ( ( P @ W13 @ W23 )
             => ( P @ W13 @ ( cons @ B @ E2 @ W23 ) ) )
         => ( P @ W1 @ W2 ) ) ) ) ).

% list_2pre_induct
thf(fact_245_zipf_Oinduct,axiom,
    ! [A: $tType,C: $tType,B: $tType,P: ( A > B > C ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B > C,A1: list @ A,A22: list @ B] :
      ( ! [F2: A > B > C] : ( P @ F2 @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [F2: A > B > C,A5: A,As: list @ A,B2: B,Bs: list @ B] :
            ( ( P @ F2 @ As @ Bs )
           => ( P @ F2 @ ( cons @ A @ A5 @ As ) @ ( cons @ B @ B2 @ Bs ) ) )
       => ( ! [A5: A > B > C,V: A,Va: list @ A] : ( P @ A5 @ ( cons @ A @ V @ Va ) @ ( nil @ B ) )
         => ( ! [A5: A > B > C,V: B,Va: list @ B] : ( P @ A5 @ ( nil @ A ) @ ( cons @ B @ V @ Va ) )
           => ( P @ A0 @ A1 @ A22 ) ) ) ) ) ).

% zipf.induct
thf(fact_246_mergesort__remdups__correct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [L: list @ A] :
          ( ( distinct @ A @ ( mergesort_remdups @ A @ L ) )
          & ( linorder_sorted @ A @ ( mergesort_remdups @ A @ L ) )
          & ( ( set2 @ A @ ( mergesort_remdups @ A @ L ) )
            = ( set2 @ A @ L ) ) ) ) ).

% mergesort_remdups_correct
thf(fact_247_product__lists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( product_lists @ A @ ( nil @ ( list @ A ) ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% product_lists.simps(1)
thf(fact_248_distinct__product__lists,axiom,
    ! [A: $tType,Xss2: list @ ( list @ A )] :
      ( ! [X2: list @ A] :
          ( ( member @ ( list @ A ) @ X2 @ ( set2 @ ( list @ A ) @ Xss2 ) )
         => ( distinct @ A @ X2 ) )
     => ( distinct @ ( list @ A ) @ ( product_lists @ A @ Xss2 ) ) ) ).

% distinct_product_lists
thf(fact_249_subset__code_I3_J,axiom,
    ! [C: $tType] :
      ~ ( ord_less_eq @ ( set @ C ) @ ( coset @ C @ ( nil @ C ) ) @ ( set2 @ C @ ( nil @ C ) ) ) ).

% subset_code(3)
thf(fact_250_combinatorial__product_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( list_c659805718roduct @ A @ ( nil @ ( list @ A ) ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% combinatorial_product.simps(1)
thf(fact_251_UNIV__coset,axiom,
    ! [A: $tType] :
      ( ( top_top @ ( set @ A ) )
      = ( coset @ A @ ( nil @ A ) ) ) ).

% UNIV_coset
thf(fact_252_subset__code_I2_J,axiom,
    ! [B: $tType,A3: set @ B,Ys: list @ B] :
      ( ( ord_less_eq @ ( set @ B ) @ A3 @ ( coset @ B @ Ys ) )
      = ( ! [X4: B] :
            ( ( member @ B @ X4 @ ( set2 @ B @ Ys ) )
           => ~ ( member @ B @ X4 @ A3 ) ) ) ) ).

% subset_code(2)
thf(fact_253_remove__code_I2_J,axiom,
    ! [A: $tType,X3: A,Xs: list @ A] :
      ( ( remove @ A @ X3 @ ( coset @ A @ Xs ) )
      = ( coset @ A @ ( insert @ A @ X3 @ Xs ) ) ) ).

% remove_code(2)
thf(fact_254_sorted__append__bigger,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Y: A] :
          ( ( linorder_sorted @ A @ Xs )
         => ( ! [X2: A] :
                ( ( member @ A @ X2 @ ( set2 @ A @ Xs ) )
               => ( ord_less_eq @ A @ X2 @ Y ) )
           => ( linorder_sorted @ A @ ( append @ A @ Xs @ ( cons @ A @ Y @ ( nil @ A ) ) ) ) ) ) ) ).

% sorted_append_bigger

%----Subclasses (4)
thf(subcl_Orderings_Olinorder___HOL_Otype,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( type @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oord,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ord @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( order @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Opreorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( preorder @ A @ ( type2 @ A ) ) ) ).

%----Type constructors (16)
thf(tcon_fun___Orderings_Oorder__top,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( order_top @ A8 @ ( type2 @ A8 ) )
     => ( order_top @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( preorder @ A8 @ ( type2 @ A8 ) )
     => ( preorder @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( order @ A8 @ ( type2 @ A8 ) )
     => ( order @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Otop,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( top @ A8 @ ( type2 @ A8 ) )
     => ( top @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( ord @ A8 @ ( type2 @ A8 ) )
     => ( ord @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder__top_1,axiom,
    ! [A7: $tType] : ( order_top @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_2,axiom,
    ! [A7: $tType] : ( preorder @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_3,axiom,
    ! [A7: $tType] : ( order @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Otop_4,axiom,
    ! [A7: $tType] : ( top @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_5,axiom,
    ! [A7: $tType] : ( ord @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_HOL_Obool___Orderings_Oorder__top_6,axiom,
    order_top @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_7,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_8,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Otop_9,axiom,
    top @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_10,axiom,
    ord @ $o @ ( type2 @ $o ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X3: A,Y: A] :
      ( ( if @ A @ $false @ X3 @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X3: A,Y: A] :
      ( ( if @ A @ $true @ X3 @ Y )
      = X3 ) ).

%----Free types (1)
thf(tfree_0,hypothesis,
    linorder @ a @ ( type2 @ a ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ord_less @ a @ x2 @ x1 ).

%------------------------------------------------------------------------------
